'use strict';

function MessageCtrl($scope, $rootScope){

    $scope.title = 'Test';
    $scope.message = 'Some message';

    $scope.messages = [];

    angular.element('#modal-message').modal({
        backdrop: 'static'
        ,keyboard: false
        ,show: false
    })

    $scope.openModal = function(){
        angular.element('#modal-message').modal('show');
    }

    $scope.closeModal = function(){
        angular.element('#modal-message').modal('hide');
    }

    $scope.$on('Message:addMsg', function(event, obj){
        $scope.messages.push(obj);
        $scope.openModal();
    });

    $scope.$on('Message:delMsg', function(event, obj){
        $scope.messages.splice($scope.messages.indexOf(obj), 1);
        if($scope.messages.length == 0)
        {
            $scope.closeModal();
        }
    });

    $scope.getIconCls = function(){
        if($scope.messages.length == 0)
        {
            return 'modal-attention';
        }
        var message = $scope.messages[0];


        if(typeof message.type == 'undefined')
        {
            return 'modal-attention';
        }
        else if(message.type == 'loading')
        {
            return 'modal-loading';
        }
        else
        {
            return 'modal-attention';
        }

    }
}

MessageCtrl.$inject = ['$scope', '$rootScope'];